% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stableGenes.R
\name{getStableGenes}
\alias{getStableGenes}
\title{Get a list of stably expressed genes}
\usage{
getStableGenes(
  n_stable,
  type = c("carcinoma", "blood", "protein"),
  id = c("geneid", "ensembl")
)
}
\arguments{
\item{n_stable}{numeric, number of stable genes to retrieve}

\item{type}{character, type of stable genes requested, stable genes in
"carcinoma" or stable genes in "blood"}

\item{id}{character, gene identifier required. This can be either "geneid"
for symbols or "ensembl" ensembl id)}
}
\value{
a character vector with gene IDs sorted by their expected expression
levels in the requested tissue
}
\description{
Get a list of genes that are stably expressed in cancer and
normal solid tissue.
}
\examples{
getStableGenes(5)
getStableGenes(5, id = 'ensembl')
getStableGenes(5, type = 'blood')

}
